﻿using System.Collections.Generic;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects.CellWalkers
{
    /// <summary>
    /// Class representing backward walker through cells taken by car.
    /// </summary>
    class BackwardCarCellWalker : BackwardCellWalker
    {
        /// <summary>
        /// Car which lies on cells to be walked.
        /// </summary>
        private Car car;

        /// <summary>
        /// Constructor of backward walker through cells by taken by car.
        /// </summary>
        /// <param name="cell">Cell from the walk starts.</param>
        /// <param name="car">Car which lies on cells to be walked.</param>
        internal BackwardCarCellWalker(Cell cell, Car car)
            : base(cell)
        {
            this.car = car;
        }

        /// <summary>
        /// Method for obtaining walked cells.
        /// </summary>
        /// <returns>Walked cells taken by car.</returns>
        internal override IEnumerable<Cell> GetNext()
        {
            foreach (Cell cell in base.GetNext())
            {
                if (cell.Car == car)
                {
                    yield return cell;
                }
                else
                {
                    yield break;
                }
            }
        }
    }
}
